//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "..\Defines.mqh"
//+------------------------------------------------------------------+
class C_Orders
{
	protected:
//+------------------------------------------------------------------+
inline const ulong GetMagicNumber(void) const { return m_Base.MagicNumber; }
//+------------------------------------------------------------------+
		bool ClosePosition(const ulong ticket)
			{
				bool	 IsBuy;
				string szContract;
				
				if	(!PositionSelectByTicket(ticket)) return false;
				IsBuy = PositionGetInteger(POSITION_TYPE) == POSITION_TYPE_BUY;
				szContract = PositionGetString(POSITION_SYMBOL);
				ZeroMemory(m_Base.TradeRequest);
				m_Base.TradeRequest.action		= TRADE_ACTION_DEAL;
				m_Base.TradeRequest.type		= (IsBuy ? ORDER_TYPE_SELL : ORDER_TYPE_BUY);
				m_Base.TradeRequest.price		= NormalizeDouble(SymbolInfoDouble(szContract, (IsBuy ? SYMBOL_BID : SYMBOL_ASK)), (int)SymbolInfoInteger(szContract, SYMBOL_DIGITS));
				m_Base.TradeRequest.position	= ticket;
				m_Base.TradeRequest.symbol		= szContract;
				m_Base.TradeRequest.volume		= PositionGetDouble(POSITION_VOLUME);
				m_Base.TradeRequest.deviation	= 1000;
				
				return SendToPhysicalServer() != 0;
			};
//+------------------------------------------------------------------+	
	private	:
//+------------------------------------------------------------------+
		struct stBase
		{
			MqlTradeRequest TradeRequest;
			ulong				 MagicNumber;
			bool				 bTrash;
		}m_Base;
//+------------------------------------------------------------------+
		struct stChartTrade
		{
			struct stEvent
			{
				EnumEvents 	ev;
				string 		szSymbol,
								szContract;
				bool			IsDayTrade;
				ushort 		Leverange;
				double		PointsTake,
								PointsStop;
			}Data;
//---
			bool Decode(const EnumEvents ev, const string sparam)
				{
					string Res[];
		
					if (StringSplit(sparam, '?', Res) != 7) return false;
					stEvent loc = {(EnumEvents) StringToInteger(Res[0]), Res[1], Res[2], (bool)(Res[3] == "D"), (ushort) StringToInteger(Res[4]), StringToDouble(Res[5]), StringToDouble(Res[6])};
					if ((ev == loc.ev) && (loc.szSymbol == _Symbol)) Data = loc;
					else return false;
					
					return true;
				}
//---
		}m_ChartTrade;
//+------------------------------------------------------------------+
		ulong SendToPhysicalServer(void)
			{
				MqlTradeCheckResult 	TradeCheck;
				MqlTradeResult    	TradeResult;
				
				ZeroMemory(TradeCheck);
				ZeroMemory(TradeResult);
				if (!OrderCheck(m_Base.TradeRequest, TradeCheck))
				{
					PrintFormat("Order System - Check Error: %d", GetLastError());
					return 0;
				}
				m_Base.bTrash = OrderSend(m_Base.TradeRequest, TradeResult);
				if (TradeResult.retcode != TRADE_RETCODE_DONE)
				{
					PrintFormat("Order System - Send Error: %d", TradeResult.retcode);
					return 0;
				};
				
				return TradeResult.order;
			}
//+------------------------------------------------------------------+	
		ulong ToMarket(const ENUM_ORDER_TYPE type)
			{
				double price 	= SymbolInfoDouble(m_ChartTrade.Data.szContract, (type == ORDER_TYPE_BUY ? SYMBOL_ASK : SYMBOL_BID));
				double vol		= SymbolInfoDouble(m_ChartTrade.Data.szContract, SYMBOL_VOLUME_STEP);
				uchar	 nDigit 	= (uchar)SymbolInfoInteger(m_ChartTrade.Data.szContract, SYMBOL_DIGITS);
				
				ZeroMemory(m_Base.TradeRequest);
				m_Base.TradeRequest.magic			= m_Base.MagicNumber;
				m_Base.TradeRequest.symbol		 	= m_ChartTrade.Data.szContract;
				m_Base.TradeRequest.price			= NormalizeDouble(price, nDigit);
				m_Base.TradeRequest.action		 	= TRADE_ACTION_DEAL;
				m_Base.TradeRequest.sl				= NormalizeDouble(m_ChartTrade.Data.PointsStop == 0 ? 0 : price + (m_ChartTrade.Data.PointsStop * (type == ORDER_TYPE_BUY ? -1 : 1)), nDigit);
				m_Base.TradeRequest.tp				= NormalizeDouble(m_ChartTrade.Data.PointsTake == 0 ? 0 : price + (m_ChartTrade.Data.PointsTake * (type == ORDER_TYPE_BUY ? 1 : -1)), nDigit);
				m_Base.TradeRequest.volume			= NormalizeDouble(vol + (vol * (m_ChartTrade.Data.Leverange - 1)), nDigit);
				m_Base.TradeRequest.type			= type;
				m_Base.TradeRequest.type_time	 	= (m_ChartTrade.Data.IsDayTrade ? ORDER_TIME_DAY : ORDER_TIME_GTC);
				m_Base.TradeRequest.stoplimit	 	= 0;
				m_Base.TradeRequest.expiration	= 0;
				m_Base.TradeRequest.type_filling	= ORDER_FILLING_RETURN;
				m_Base.TradeRequest.deviation	 	= 1000;
				m_Base.TradeRequest.comment		= "Order Generated by Experts Advisor.";

				MqlTradeRequest TradeRequest[1];

				TradeRequest[0] = m_Base.TradeRequest;
				ArrayPrint(TradeRequest);

				return (((type == ORDER_TYPE_BUY) || (type == ORDER_TYPE_SELL)) ? SendToPhysicalServer() : 0);
			};
//+------------------------------------------------------------------+
		void CloseAllsPosition(void)
			{
				for (int count = PositionsTotal() - 1; count >= 0; count--)
				{
					if (PositionGetSymbol(count) != m_ChartTrade.Data.szContract) continue;
					if (PositionGetInteger(POSITION_MAGIC) != m_Base.MagicNumber) continue;
					ClosePosition(PositionGetInteger(POSITION_TICKET));
				}
			};
//+------------------------------------------------------------------+	
	public	:
//+------------------------------------------------------------------+
		C_Orders(const ulong magic)
			{
				m_Base.MagicNumber = magic;
			}
//+------------------------------------------------------------------+	
		void DispatchMessage(const int id, const long &lparam, const double &dparam, const string &sparam)
			{
				switch (id)
				{
					case CHARTEVENT_CUSTOM + evChartTradeBuy		:
					case CHARTEVENT_CUSTOM + evChartTradeSell		:
					case CHARTEVENT_CUSTOM + evChartTradeCloseAll:
						if (m_ChartTrade.Decode((EnumEvents)(id - CHARTEVENT_CUSTOM), sparam)) switch (m_ChartTrade.Data.ev)
						{
							case evChartTradeBuy:
								ToMarket(ORDER_TYPE_BUY);
								break;
							case evChartTradeSell:
								ToMarket(ORDER_TYPE_SELL);
								break;
							case evChartTradeCloseAll:
								CloseAllsPosition();
								break;
						}
						break;
				}
			}
//+------------------------------------------------------------------+	
};
//+------------------------------------------------------------------+